package automobile;


/**
 * Gestion d'un compteur pour un véhicule
 * Contient un totalisateur et un compeur partiel, réinitialisé tous les 1000 Km
 * @author Adrien Poupa
 */
public class Compteur {

    private int totalisateur;
    private int partiel;

    // Constante de réinitialisation fixée à 1000 Km
    private static final int reset = 1000;

    /**
     * Constructeur par défaut
     * Initialise les attributs compteurs totalisateur et partiel à 0
     */
    public Compteur() {
        totalisateur = 0;
        partiel = 0;
    }

    /**
     * Getter du totalisateur
     * @return totalisateur, nombre de kilomètres parcourus depuis l'instanciation
     */
    public int getTotalisateur() {
        return totalisateur;
    }

    /**
     * Getter du compteur partiel
     * @return partiel, nombre de kilomètres (inferieur à 1000) dans le compteur partiel
     */
    public int getPartiel() {
        return partiel;
    }

    /**
     * Setter intelligent du compteur partiel
     * On ajoute le nombre de kilomètres donnés en paramètre si le total du partiel actuel
     * et du nouveau nombre kilomètres donné est inférieur à la constante de reset de 1000KM
     * Sinon, on calcule le reste et on ajoute ce dernier.
     * @param kilometers, nombre de kilomètres à ajouter dans le compteur partiel
     */
    public void setPartiel(int kilometers) {
        this.partiel += kilometers; // Total potentiel du compteur partiel
        // Si on dépasse la limite fatidique des 1000Km
        if (this.partiel > reset) {
            int reste = this.partiel - reset; // Calcul du reste
            resetPartiel(); // Remise à zéro du compteur partiel
            partiel = reste; // Insertion des kilomètres restants
        }
    }

    /**
     * Réinitialise le compteur partiel à 0
     */
    public void resetPartiel() {
        partiel = 0;
    }

    /**
     * Insertion des kilomètres passés en paramètres dans les deux compteurs
     * @param kilometers kilomètres à ajouter
     */
    public void add(int kilometers) {
        setPartiel(kilometers);
        totalisateur += kilometers;
    }

    /**
     * Surcharge de toString
     * @return Compteur = [Totalisateur= X | Partiel= X];
     */
    @Override
    public String toString() {
        return "Compteur = [" +"Totalisateur=" + totalisateur + " | Partiel=" + partiel + "];";
    }
}
